# Work Speaks Protocol (WSP) — White Paper v1.0 (ReleasePack)

This ReleasePack contains the Work Speaks Protocol (WSP) White Paper v1.0 in PDF and source format.

WSP is a receipts-first protocol for independent projects: it defines how to create a public Proof Trail using versioned bundles, SHA-256 hashes, timestamp anchoring under a project provenance identity, and a public Artifacts Index that maps each hash to its downloadable bundle and context.

## Contents
- WSP_WhitePaper_v1.0.pdf
- WSP_WhitePaper_v1.0.docx
- README.md (this file)
- LICENSES.md

## Verification (how to verify this ReleasePack)
This zip bundle is intended to be committed as a WSP artifact:

1) Compute the SHA-256 hash of this zip file (the exact bytes of the zip).
2) Verify that hash matches the project’s Proof Trail / Artifacts Index entry for this ReleasePack.
3) Verify that the same hash is present in the public timestamp record (anchor reference) attributable to the project’s provenance identity.

Note: a bundle cannot include its own SHA-256 hash inside itself without recursion. The canonical hash and timestamp reference are recorded externally in the Proof Trail entry for this ReleasePack.

## Where to find the Proof Trail entry
The canonical Proof Trail / Artifacts Index entry for this ReleasePack will be published on the project website shortly after release:

https://absoluterelativity.org

(Once live, the WSP page and Artifacts Index will provide the exact download mirrors, bundle hash, timestamp reference, and provenance identity.)

## License
See LICENSES.md.
